-- bar widths used to be SCREEN_WIDTH*0.8, now they're 512
local sliderWidth = 512;

local gc = Var("GameCommand");
local index = gc:GetIndex();
local name = gc:GetName();

local filterColor = GetUserPref("FilterColorP2");

-- UI
local focusTime = 0.15;

local t = Def.ActorFrame{
	-- label
	AutoText("frutiger")..{
		Text=name;
		InitCommand=cmd(horizalign,right;shadowlength,1;maxwidth,96;NoStroke);
		BeginCommand=function(self)
			if name ~= "Exit" then
				local normalPos = -(SCREEN_CENTER_X*0.825);
				local widePos = (-(SCREEN_CENTER_X*0.7));
				
				local text = self:GetText();
				if IsUsingWideScreen() == false then
					self:x(normalPos);
					-- substring
					self:settext( string.sub(text,1,3) );
				else
					self:x(widePos);
					self:settext(text);
				end;
			end;
		end;
		GainFocusCommand=function(self)
			MESSAGEMAN:Broadcast("HSVFocusChanged",{ NewIndex = index, NewName = name })
			--self:diffuse( filterColor );
			self:stoptweening();
			self:accelerate(focusTime);
			self:diffuse( color("1,0,0,1") );
		end;
		LoseFocusCommand=function(self)
			--self:diffuse( Saturation(filterColor,0.5) )
			self:stoptweening();
			self:accelerate(focusTime);
			self:diffuse( color("1,1,1,1") );
		end;
		UpdateBackgroundColorMessageCommand=function(self,params)
			curColor = params.Color;
		end;
		OffFocusedCommand=function(self)
			if ScreensAndPrefs[CallingScreen] ~= nil then
				SetUserPref("FilterColorP2", "#"..ColorToHex(curColor) );
			end;
		end;
	};

	Def.Quad{
		Name="SliderRange";
		InitCommand=cmd(zoomto,sliderWidth,4;y,4;diffusealpha,0.5;diffusetopedge,color("1,1,1,0.5");diffusebottomedge,color("0.5,0.5,0.5,0.5");blend,'BlendMode_Add');
		BeginCommand=function(self)
			if name == "Exit" then self:visible(false);
			else self:visible(true);
			end;

			if name == "Alpha" then
				self:addy(-4);
			end;
		end;
	};
};

return t;